%% DATI NUMERICI
clc
MACH = 8;
a_cr = 303.39;
CEF_1972_to_2022 = 292.66/41.85;
Average_exchange_rate_2022_DOLLARS_TO_EUROS = 0.951;

C_HST = (Mean_Cost_TOT_MilioniEuro_2022 + C_RDTE_MEAN_TOT_MILIONIEURO) *1000000;
C_TJ = (Mean_Fcce_MilioniEuro_2022 + C_RDTE_MEAN_HCCE_MILIONIEURO) *1000000;
C_RJ = (Mean_Fer_MilioniEuro_2022 + C_RDTE_MEAN_HER_MILIONIEURO)*1000000;
INPUT_COSTS = ["C_HST";"C_TJ";"C_RJ"];
MilionEUROS = [C_HST/1000000;C_TJ/1000000;C_RJ/1000000];
INPUT_COSTS_FOR_OPS = table(INPUT_COSTS,MilionEUROS) 

W_FUEL = 180000;                                                              %[kg]
Cost_FUEL = 5.2;                                                             %[€/kg]
Cost_FUEL_min = 1.31; 
pax_average_weight = 110;                                                  %[kg/pax]
W_PL = 33000;                                                                %[kg]
pax = W_PL/pax_average_weight;
K_R = 0.08;                                                                %Reserve_fuel_fraction
W_GTO = 400000;                                                             %[kg] maximum take-off weight/gross weight
L_F = 0.75;                                                                %load factor
R_T = 19000;                                                               %[km] Operational_range


t_f =  12239;                                                                 %[s] Flight_time
t_f_h = t_f/3600;                                                    %[hr] Flight_time_hours
t_b = t_f*1.2;                                                      %[s] Block_time
t_b_h = t_b/3600;                                                    %[hr] Block_time_hours
V_b_kmh = R_T/t_b_h;                                                   %[km/h] Block_speed_kmh
V_cr_kmh = MACH * a_cr * 3.6;
Flight_per_days = 2;

IR =  0.02;                                                %[%] Annual_insurance_rate 
Total_flights_per_years = Flight_per_days*305;                             %[flight/year]

L_d = 10;                                                    %[years] Depreciation_life
Total_flights = Total_flights_per_years * L_d;               %[flights]

U = t_b_h * Total_flights_per_years;                     %[hr/year] Utilization

R_L = 5.3*CEF_1972_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;                   %[€/manhours] Average_maintenance_labor_rate

W_AV = 600;                                                      %[kg]
Misc_weight =  0;                                                 %[kg]        %crew, residuals, power reserve and in-flight losses
W_TJ = 4000;
W_RJ = 1400;

W_AF = W_GTO - (W_FUEL + (6*W_TJ) + W_RJ + W_AV + W_PL + Misc_weight ); 


K_LTJ = 2;
K_MTJ = 2;
K_LRJ = 2;
K_MRJ = 3;
N_RJ = 1;

Kt_TJ=0.25;
Kt_RJ=0.55;

T_TO_ATR = 1724*1000;
T_TO_SINGLE = 1724*1000/6;                                                         %THRUST TAKE_OFF single engine [N]

LIFT_TO_DRAG = 6.5;

CONVERSION_TO_EURO_PER_BLOCKHOUR = L_F*(W_PL/2000)*680*MACH*(V_b_kmh/V_cr_kmh);
CONVERSION_TO_EURO_PER_FLIGHT = CONVERSION_TO_EURO_PER_BLOCKHOUR * (R_T/(680*MACH*(V_b_kmh/V_cr_kmh)));


Enplaned_pax = pax*L_F;
%% DOC FUEL

DOC_FUEL = (1460*Cost_FUEL*(W_FUEL/W_GTO)*(1-K_R))/(L_F*(W_PL/W_GTO)*R_T);


%% DOC CREW

DOC_CREW = ((320/W_GTO)/(0.725*L_F*(W_PL/W_GTO)*MACH*(V_b_kmh/V_cr_kmh)))*CEF_1972_to_2022;


%% DOC INSURANCE

DOC_INSURANCE = (IR*(C_HST/W_GTO))/(0.725*L_F*(W_PL/W_GTO)*MACH*(V_b_kmh/V_cr_kmh)*U);


%% DOC DEPRECIATION

DOC_DEPRECIATION = ((1.1*(C_HST/W_GTO))+(0.3*((C_TJ+C_RJ)/W_GTO)))/(0.725*L_F*(W_PL/W_GTO)*MACH*(V_b_kmh/V_cr_kmh)*U*L_d);


%% DOC MAINTENANCE

coeff = ((6/W_GTO)-(630/(W_GTO*(((W_AF+W_AV))+120))))*1000;

DOC_M_AF_L = ((3.22+(1.93*t_f_h))*(MACH^0.5)*R_L*(coeff+(0.05*((W_AF+W_AV)/W_GTO))))/(L_F*(W_PL/W_GTO)*R_T);

DOC_M_AF_M = ((9.04+(4.52*t_f_h))*((C_HST-(C_TJ+C_RJ))/W_GTO))/(L_F*(W_PL/W_GTO)*R_T*1000);

DOC_M_TJ_L = ((T_TO_SINGLE/W_GTO)*(1+(0.3*t_f_h*Kt_TJ))*(MACH^0.5)*R_L*K_LTJ*(0.087+(8.6/(T_TO_SINGLE/1000))))/(L_F*(W_PL/W_GTO)*R_T);%CEF?

DOC_M_TJ_M = ((C_TJ/W_GTO)*(0.029+(0.011*t_f_h*Kt_TJ))*K_MTJ)/(L_F*(W_PL/W_GTO)*R_T);

DOC_M_RJ_L = ((1+(t_f_h*Kt_RJ))*R_L*K_LRJ*((0.876*LIFT_TO_DRAG*N_RJ)/(W_GTO/1000)+0.087))/(L_F*(W_PL/W_GTO)*R_T*LIFT_TO_DRAG);%CEF?

DOC_M_RJ_M = ((C_RJ/W_GTO)*(0.029+(0.036*t_f_h*Kt_RJ))*K_MRJ)/(L_F*(W_PL/W_GTO)*R_T);

DOC_MAINTENANCE = DOC_M_AF_L + DOC_M_AF_M + DOC_M_TJ_L + DOC_M_TJ_M + DOC_M_RJ_L + DOC_M_RJ_M;

%% DOC TABLE

DOC_TOT = DOC_MAINTENANCE + DOC_DEPRECIATION + DOC_INSURANCE + DOC_CREW + DOC_FUEL;


DOC_NAME = ["DOC_FUEL";"DOC_CREW";"DOC_INSURANCE";"DOC_DEPRECIATION";"DOC_M_AF_L";"DOC_M_AF_M";
            "DOC_M_TJ_L";"DOC_M_TJ_M";"DOC_M_RJ_L";"DOC_M_RJ_M";"DOC_MAINTENANCE"];
DOC_NAME_FIVE = ["DOC_FUEL";"DOC_CREW";"DOC_INSURANCE";"DOC_DEPRECIATION";"DOC_MAINTENANCE";"TOTAL OPERATING COST"];

DOLLARS_PER_TONMILES =[DOC_FUEL;DOC_CREW;DOC_INSURANCE;DOC_DEPRECIATION;DOC_M_AF_L;DOC_M_AF_M;
                       DOC_M_TJ_L;DOC_M_TJ_M;DOC_M_RJ_L;DOC_M_RJ_M;DOC_MAINTENANCE];
DOLLARS_PER_TONMILES_FIVE = [DOC_FUEL;DOC_CREW;DOC_INSURANCE;DOC_DEPRECIATION;DOC_MAINTENANCE;DOC_TOT];
                   
EUROS_PER_FLIGHT = CONVERSION_TO_EURO_PER_FLIGHT*DOLLARS_PER_TONMILES;
EUROS_PER_FLIGHT_FIVE = CONVERSION_TO_EURO_PER_FLIGHT*DOLLARS_PER_TONMILES_FIVE;

EUROS_PER_FLIGHT_PER_PAX_LF75 = EUROS_PER_FLIGHT/Enplaned_pax;
EUROS_PER_FLIGHT_FIVE_PER_PAX_LF75 = EUROS_PER_FLIGHT_FIVE/Enplaned_pax;

EUROS_PER_FLIGHT_PER_KM_PAX_LF75 = EUROS_PER_FLIGHT/(R_T*Enplaned_pax);
EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_LF75 = EUROS_PER_FLIGHT_FIVE/(R_T*Enplaned_pax);

EUROS_PER_FLIGHT_PER_PAX_LF100 = EUROS_PER_FLIGHT/pax;
EUROS_PER_FLIGHT_FIVE_PER_PAX_LF100 = EUROS_PER_FLIGHT_FIVE/pax;

EUROS_PER_FLIGHT_PER_KM_PAX_LF100 = EUROS_PER_FLIGHT/(R_T*pax);
EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_LF100 = EUROS_PER_FLIGHT_FIVE/(R_T*pax);

EUROS_PER_BLOCK_HOUR = EUROS_PER_FLIGHT/(R_T/(680*MACH*(V_b_kmh/V_cr_kmh)));
EUROS_PER_BLOCK_HOUR_FIVE = EUROS_PER_FLIGHT_FIVE/(R_T/(680*MACH*(V_b_kmh/V_cr_kmh)));

DOC_PERCENTAGES = 100*EUROS_PER_FLIGHT/(EUROS_PER_FLIGHT_FIVE(6));
DOC_PERCENTAGES_FIVE = 100*EUROS_PER_FLIGHT_FIVE/(EUROS_PER_FLIGHT_FIVE(6));

DOC = table(DOC_NAME,DOC_PERCENTAGES,DOLLARS_PER_TONMILES,EUROS_PER_FLIGHT,EUROS_PER_BLOCK_HOUR,EUROS_PER_FLIGHT_PER_PAX_LF75,EUROS_PER_FLIGHT_PER_KM_PAX_LF75,EUROS_PER_FLIGHT_PER_PAX_LF100,EUROS_PER_FLIGHT_PER_KM_PAX_LF100) 
DOC_FIVE = table(DOC_NAME_FIVE,DOC_PERCENTAGES_FIVE,DOLLARS_PER_TONMILES_FIVE,EUROS_PER_FLIGHT_FIVE,EUROS_PER_BLOCK_HOUR_FIVE,EUROS_PER_FLIGHT_FIVE_PER_PAX_LF75,EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_LF75,EUROS_PER_FLIGHT_FIVE_PER_PAX_LF100,EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_LF100)

format('bank')

writetable(DOC,'MR5.xlsx','Sheet','OPS_DOC','Range','J2');
writetable(DOC_FIVE,'MR5.xlsx','Sheet','OPS_DOC','Range','J15');

LFvariation=0.5:0.01:1;
enplaned_pax_variation = pax.*LFvariation;
EUROS_PER_FLIGHT_FIVE_PER_PAX_VARIATION = EUROS_PER_FLIGHT_FIVE(6)./enplaned_pax_variation;
EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_VARIATION = EUROS_PER_FLIGHT_FIVE(6)./(R_T*enplaned_pax_variation);
figure(1)
plot(LFvariation,EUROS_PER_FLIGHT_FIVE_PER_PAX_VARIATION,'r','LineWidth',1.5)
hold on
grid on
xlabel({'Aircraft Load Factor'})
ylabel({'[€/pax FY2022]'})
figure(2)
plot(LFvariation,EUROS_PER_FLIGHT_FIVE_PER_KM_PAX_VARIATION,'g','LineWidth',1.5)
hold on
grid on
xlabel({'Aircraft Load Factor'})
ylabel({'[€/pax*km FY2022]'})

%% IOC




General_and_Administrative = 0.0072*pax*R_T*CEF_2013_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;%CHANGE DOLLARS EURO

Reservation_Ticketing_Sales_and_Promotion = 0.0076*pax*R_T*CEF_2013_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;%CHANGE DOLLARS EURO

Station_and_Ground = 0.0092*pax*R_T*CEF_2013_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;%CHANGE DOLLARS EURO 

Airport_Charges_and_AirNavigation_Charges = 0.0083*pax*R_T*CEF_2013_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;%CHANGE DOLLARS EURO 

Passenger_Service_and_Cabin_Attendants = 0.015*Enplaned_pax*R_T*CEF_2017_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;

Aircraft_Servicing_Costs = 800*CEF_2017_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;

Traffic_Servicing_Costs = 15*Enplaned_pax*CEF_2017_to_2022*Average_exchange_rate_2022_DOLLARS_TO_EUROS;


%% IOC TABLE

IOC_TOT = General_and_Administrative + Reservation_Ticketing_Sales_and_Promotion + Station_and_Ground + Airport_Charges_and_AirNavigation_Charges + Passenger_Service_and_Cabin_Attendants + Aircraft_Servicing_Costs + Traffic_Servicing_Costs; 

IOC_NAME = ["General and Administrative";"Reservation Ticketing Sales and Promotion";"Station and Ground";
            "Airport Charges and Air Navigation Charges";"Passenger Service and Cabin Attendants";"Aircraft Servicing Costs";
            "Traffic Servicing Costs";"Total Indirect Operating Costs"];
        
EUROS_PER_FLIGHT = [General_and_Administrative;Reservation_Ticketing_Sales_and_Promotion;Station_and_Ground;Airport_Charges_and_AirNavigation_Charges;Passenger_Service_and_Cabin_Attendants;Aircraft_Servicing_Costs;Traffic_Servicing_Costs;IOC_TOT];
EUROS_PER_FLIGHT_PER_PAX = EUROS_PER_FLIGHT/Enplaned_pax;
EUROS_PER_BLOCK_HOUR = EUROS_PER_FLIGHT/(R_T/(680*MACH*(V_b_kmh/V_cr_kmh)));

IOC_PERCENTAGES = 100*EUROS_PER_FLIGHT/IOC_TOT;

IOC = table(IOC_NAME,IOC_PERCENTAGES,EUROS_PER_FLIGHT,EUROS_PER_BLOCK_HOUR,EUROS_PER_FLIGHT_PER_PAX)

writetable(IOC,'MR5.xlsx','Sheet','OPS_IOC','Range','H2');

%% TOC
format('bank')

TOC_Value = (DOC_TOT*CONVERSION_TO_EURO_PER_FLIGHT) + IOC_TOT;
DOC_TOT_EUROS_PER_FLIGHT = DOC_TOT*CONVERSION_TO_EURO_PER_FLIGHT;

EUROS_PER_FLIGHT = [DOC_TOT_EUROS_PER_FLIGHT;IOC_TOT;TOC_Value];
EUROS_PER_FLIGHT_PER_PAX = EUROS_PER_FLIGHT/Enplaned_pax;
EUROS_PER_BLOCK_HOUR = EUROS_PER_FLIGHT/(R_T/(680*MACH*(V_b_kmh/V_cr_kmh)));
EUROS_PER_KM_PER_PAX = EUROS_PER_FLIGHT/(R_T*Enplaned_pax);
EUROS_PER_KM_PER_PAX100 = EUROS_PER_FLIGHT/(R_T*pax)

TOC_PERCENTAGES = 100*EUROS_PER_FLIGHT/TOC_Value;

TOC_NAME = ["DIRECT OPERATING COST";"INDIRECT OPERATING COST";"TOTAL OPERATING COST"];

TOC = table(TOC_NAME,TOC_PERCENTAGES,EUROS_PER_FLIGHT,EUROS_PER_BLOCK_HOUR,EUROS_PER_FLIGHT_PER_PAX,EUROS_PER_KM_PER_PAX)

writetable(TOC,'MR5.xlsx','Sheet','OPS_TOC','Range','G2');

